<?php
/**
 * Elementor Montoya Moving Thumbs Grid Widget.
 *
 * Elementor widget that inserts a thumbs gallery with interesting moving effect on scroll.
 *
 * @since 1.0.0
 */
class Elementor_Montoya_Moving_Thumbs_Grid_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Moving Thumbs Grid widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'montoya_moving_thumbs_grid';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Moving Thumbs Grid widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Moving Thumbs Grid', 'montoya-elementor-widgets' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve moving thumbs grid widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the moving thumbs grid widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'montoya-widgets' ];
	}

	/**
	 * Register Moving Thumbs Grid widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'montoya-elementor-widgets' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __( 'Grid Title', 'montoya-elementor-widgets' ),
				'type' => \Elementor\Controls_Manager::CODE,
				'language' => 'html',
				'rows' => 20,
			]
		);
		
		$this->add_control(
			'gallery',
			[
				'label' => __( 'Add Images To Moving Thumbs Gallery', 'montoya-elementor-widgets' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
			]
		);
		
		$this->end_controls_section();

	}

	/**
	 * Render Moving Thumbs Grid widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$settings = $this->get_settings_for_display();

		echo '<div class="move-thumbs-wrapper">';
		
		// Grid title
		echo '<div class="start-thumbs-caption">';
		echo wp_kses_post( $settings['title'] );
		echo '</div>';
		
		// Grid Thumb Images
		echo '<div class="start-thumbs-wrapper">';
		foreach ( $settings['gallery'] as $image ) {

			$image_alt = get_post_meta( $image['id'], '_wp_attachment_image_alt', TRUE );

			echo '<div class="start-move-thumb">';
			echo '<div class="move-thumb-inner">';
			echo '<div class="section-image">';
			echo '<img src="' . esc_url( $image['url'] ) . '" class="item-image" alt="' . esc_attr( $image_alt ) . '" />';
			echo '</div>';
			echo '</div>';
			echo '</div>';

		}
		echo '</div>';
		
		echo '</div>';
		
	}

}

?>
