<?php
/**
 * Elementor Montoya List Rotator Widget.
 *
 * Elementor widget that inserts a list of items rotating on scroll.
 *
 * @since 1.0.0
 */
class Elementor_Montoya_List_Rotator_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve List Rotator widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'montoya_list_rotator';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve List Rotator widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'List Rotator', 'montoya-elementor-widgets' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve list rotator widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-wrap';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the list rotator widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'montoya-widgets' ];
	}

	/**
	 * Register List Rotator widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'montoya-elementor-widgets' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'List Title', 'montoya-elementor-widgets' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'show_label' => true,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'item_text',
			[
				'label' => __( 'List Item Text (HTML allowed)', 'montoya-elementor-widgets' ),
				'type' => \Elementor\Controls_Manager::CODE,
				'language' => 'html',
				'rows' => 20,
			]
		);

		$this->add_control(
			'list_items',
			[
				'label' => __( 'List Items', 'montoya-elementor-widgets' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'item_text' => __( 'List Item #1', 'montoya-elementor-widgets' )
					],
					[
						'item_text' => __( 'List Item #2', 'montoya-elementor-widgets' )
					],
				]
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render List Rotator widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$settings = $this->get_settings_for_display();

		echo '<div class="list-rotator-wrapper">';
		echo '<div class="list-rotator-title">' . wp_kses_post( $settings['title'] ) . '</div>';
		echo '<div class="list-rotator-pin">';
		echo '<ul class="list-rotator primary-font-title">';
		foreach ( $settings['list_items'] as $item ) {
			
			echo '<li>' . wp_kses_post( $item['item_text'] ) . '</li>';
		}
		echo '</ul>';
		echo '</div>';
		echo '</div>';

	}

}

?>
